<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('doctor_id');
			$table->decimal('admin_commission_per')->nullable();
			$table->decimal('admin_commission')->nullable();
			$table->decimal('total')->nullable();
			$table->decimal('final_total')->nullable();
			$table->integer('status');
			$table->integer('pay_type');
			$table->integer('pay_status');
			$table->string('pay_data')->nullable();
			$table->integer('room_id')->nullable();
			$table->boolean('is_rate')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}