<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Wallet extends Eloquent {

	protected $table = 'wallets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'amount', 'invoice_id', 'payment_status');

	public function user()
	{
		return $this->belongsTo('App\Models\Users');
	}

}