<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function role()
    {
        return $this->hasOne('App\Roles', 'role_id');
    }

    public function templates()
    {
        return $this->hasMany('App\Users');
    }

    public function courseClass()
    {
        return $this->hasOne('App\CourseClass', 'course_class_id');
    }

    public function agent()
    {
        return $this->hasOne('App\Users', 'agent_id');
    }

    public function avatar()
    {
        return $this->hasOne('App\Avatars', 'avatar_id');
    }

}