<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillingTable extends Migration {

	public function up()
	{
		Schema::create('billing', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('company_id');
			$table->integer('plan_id')->unsigned();
			$table->float('price');
			$table->enum('month', array(''JAN'', ''FEB'', ''MAR'', ''APR'', ''MAY'', ''JUN'', ''JUL'', ''AUG'', ''SEP'', ''OCT'', ''NOV'', ''DEC''));
			$table->enum('type', array(''MONTHLY'', ''HALF_YEARLY'', ''YEARLY''));
		});
	}

	public function down()
	{
		Schema::drop('billing');
	}
}