<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTSurveyTable extends Migration {

	public function up()
	{
		Schema::create('t_survey', function(Blueprint $table) {
			$table->increments('id');
			$table->string('surTitle', 50);
			$table->text('surDesc');
			$table->string('surSeed');
			$table->string('surHexUser', 11)->unique()->nullable();
			$table->string('surHexAdmin', 11)->unique()->nullable();
			$table->tinyInteger('surIsValidated');
			$table->datetime('surLastConnection');
			$table->string('surAdminFirstname', 50);
			$table->string('surAdminLastname', 50);
			$table->string('surAdminEmail', 50);
		});
	}

	public function down()
	{
		Schema::drop('t_survey');
	}
}