<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Lawyer extends Model 
{

    protected $table = 'lawyers';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function province()
    {
        return $this->belongsTo('City');
    }

    public function low_category()
    {
        return $this->belongsToMany('LawCategory');
    }

    public function education()
    {
        return $this->hasMany('Educations');
    }

    public function work_history()
    {
        return $this->hasOne('LawyerWorkHistory');
    }

    public function articale()
    {
        return $this->hasMany('LawyerArticle');
    }

    public function court()
    {
        return $this->belongsToMany('Court');
    }

}