<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSiteSettingsTable extends Migration {

	public function up()
	{
		Schema::create('site_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('logo', 50)->nullable();
			$table->string('small_description', 50)->nullable();
			$table->string('email_id', 30)->nullable();
			$table->integer('phone_number')->nullable();
			$table->string('social_links', 50)->nullable();
			$table->string('meta_title', 50)->nullable();
			$table->text('meta_description')->nullable();
			$table->string('meta_tag', 50)->nullable();
			$table->string('script', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('site_settings');
	}
}