<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeIdentitiesTable extends Migration {

	public function up()
	{
		Schema::create('employee_identities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('identity_code', 20);
			$table->date('expiry_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('category_name');
			$table->string('category_name_en')->nullable();
			$table->string('job_name');
			$table->string('job_name_en');
		});
	}

	public function down()
	{
		Schema::drop('employee_identities');
	}
}