<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobInformationsTable extends Migration {

	public function up()
	{
		Schema::create('job_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id');
			$table->string('job_title', 255);
			$table->string('job_title_en')->nullable();
			$table->integer('employee_id')->unsigned();
			$table->integer('structure_type_id')->unsigned();
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('job_informations');
	}
}