<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeIdentity extends Eloquent {

	protected $table = 'employee_identities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}