<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Study extends Eloquent {

	protected $table = 'studies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function academicAchievement()
	{
		return $this->belongsTo('AcademicAchievement', 'academic_achievement');
	}

}