<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyPaymentTable extends Migration {

	public function up()
	{
		Schema::create('plenty_payment', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('amount', 13,4);
			$table->decimal('exchangeRatio', 13,4);
			$table->integer('mopId')->unsigned();
			$table->integer('parentId')->unsigned();
			$table->tinyInteger('deleted');
			$table->tinyInteger('unaccountable');
			$table->string('currency', 5);
			$table->enum('type', array('debit', 'credit'));
			$table->string('origin', 45);
			$table->string('hash', 32);
			$table->timestamp('entryDate');
			$table->timestamp('importDate');
			$table->integer('status')->unsigned();
			$table->integer('transactionType')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('plenty_payment');
	}
}