<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInsurancePlansTable extends Migration {

	public function up()
	{
		Schema::create('insurance_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('country_id')->unsigned();
			$table->smallInteger('min_age')->unsigned();
			$table->smallInteger('max_age')->unsigned();
			$table->smallInteger('min_duration')->unsigned();
			$table->smallInteger('max_duration')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->integer('price')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('insurance_plans');
	}
}