<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class List extends Model 
{

    protected $table = 'lists';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'shop_id');

    public function shop()
    {
        return $this->belongsTo('Shop');
    }

    public function items()
    {
        return $this->hasMany('Item');
    }

}