<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Month extends Model 
{

    protected $table = 'months';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function exspenses()
    {
        return $this->hasMany('Exspense');
    }

    public function income()
    {
        return $this->hasMany('Income');
    }

}