<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('race_id')->references('id')->on('races')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('player_type_id')->references('id')->on('player_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players_skills', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('receiver')->on('conversations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('receiver')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->foreign('message')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('blog_post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('reject_id')->references('id')->on('rejects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images_tags', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rejects', function(Blueprint $table) {
			$table->foreign('rejected_by')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rejects', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players_conversations', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('players_conversations', function(Blueprint $table) {
			$table->foreign('conversation_id')->references('receiver')->on('conversations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams_players', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams_players', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles_games', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles_games', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams_games', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams_games', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('upgrades', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_location_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_profile_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_race_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_player_type_id_foreign');
		});
		Schema::table('players_skills', function(Blueprint $table) {
			$table->dropForeign('players_skills_player_id_foreign');
		});
		Schema::table('players_skills', function(Blueprint $table) {
			$table->dropForeign('players_skills_skill_id_foreign');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->dropForeign('games_location_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_conversation_id_foreign');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_receiver_foreign');
		});
		Schema::table('conversations', function(Blueprint $table) {
			$table->dropForeign('conversations_message_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_blog_post_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_profile_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_reject_id_foreign');
		});
		Schema::table('images_tags', function(Blueprint $table) {
			$table->dropForeign('images_tags_tag_id_foreign');
		});
		Schema::table('images_tags', function(Blueprint $table) {
			$table->dropForeign('images_tags_image_id_foreign');
		});
		Schema::table('rejects', function(Blueprint $table) {
			$table->dropForeign('rejects_rejected_by_foreign');
		});
		Schema::table('rejects', function(Blueprint $table) {
			$table->dropForeign('rejects_blog_id_foreign');
		});
		Schema::table('players_conversations', function(Blueprint $table) {
			$table->dropForeign('players_conversations_profile_id_foreign');
		});
		Schema::table('players_conversations', function(Blueprint $table) {
			$table->dropForeign('players_conversations_conversation_id_foreign');
		});
		Schema::table('teams_players', function(Blueprint $table) {
			$table->dropForeign('teams_players_team_id_foreign');
		});
		Schema::table('teams_players', function(Blueprint $table) {
			$table->dropForeign('teams_players_player_id_foreign');
		});
		Schema::table('profiles_games', function(Blueprint $table) {
			$table->dropForeign('profiles_games_profile_id_foreign');
		});
		Schema::table('profiles_games', function(Blueprint $table) {
			$table->dropForeign('profiles_games_game_id_foreign');
		});
		Schema::table('teams_games', function(Blueprint $table) {
			$table->dropForeign('teams_games_team_id_foreign');
		});
		Schema::table('teams_games', function(Blueprint $table) {
			$table->dropForeign('teams_games_game_id_foreign');
		});
		Schema::table('upgrades', function(Blueprint $table) {
			$table->dropForeign('upgrades_player_id_foreign');
		});
	}
}