<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Game extends Eloquent {

	protected $table = 'games';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function location()
	{
		return $this->hasOne('App\Classes\Location');
	}

	public function teams()
	{
		return $this->belongsToMany('App\Classes\Team');
	}

	public function profiles()
	{
		return $this->belongsToMany('App\Classes\Profile');
	}

}