<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function players()
	{
		return $this->hasMany('App\Classes\Player');
	}

	public function games()
	{
		return $this->hasMany('App\Classes\Game');
	}

}