<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentRequestTable extends Migration {

	public function up()
	{
		Schema::create('shipment_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->boolean('client_accepted')->nullable()->default(false);
			$table->boolean('driver_accepted')->nullable()->default(false);
			$table->enum('status', array('created', 'pending', 'confirmed', 'canceled'))->nullable();
			$table->decimal('price');
			$table->integer('client_id')->unsigned();
			$table->integer('driver_id')->unsigned();
			$table->integer('freight_id')->unsigned();
			$table->string('capacity', 255)->nullable();
			$table->text('request_text')->nullable();
			$table->string('pickup_address', 255);
			$table->string('pickup_address_no', 255);
			$table->string('pickup_postcode', 255);
			$table->string('pickup_city', 255);
			$table->string('pickup_region', 255);
			$table->string('telephone', 255)->nullable();
			$table->text('response_text')->nullable()->default('50');
		});
	}

	public function down()
	{
		Schema::drop('shipment_request');
	}
}