<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderSlot extends Model 
{

    protected $table = 'order_slot';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slot_id', 'order_service_id');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function slot()
    {
        return $this->belongsTo('Slot', 'slot_id');
    }

    public function order_service()
    {
        return $this->belongsTo('OrderService', 'order_service_id');
    }

}