<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->datetime('date')->nullable();
			$table->enum('type', array('private', 'regular'))->nullable();
			$table->string('total_duration')->nullable();
			$table->double('services_price')->nullable();
			$table->double('private_price')->nullable();
			$table->double('total_price')->nullable();
			$table->enum('status', array('new', 'booked', 'cancelled', 'changed', 'completed'))->nullable();
			$table->integer('offer_id')->nullable();
			$table->integer('discount_id')->nullable();
			$table->integer('rating_id')->nullable();
			$table->integer('branch_id')->nullable()->default('1');
			$table->string('odoo_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}