<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatingServiceTable extends Migration {

	public function up()
	{
		Schema::create('rating_service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->integer('rating_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('worker_id')->nullable();
			$table->integer('rate')->nullable();
			$table->boolean('show')->default(1);
			$table->string('review')->nullable();
			$table->integer('branch_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rating_service');
	}
}