<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OfferProduct extends Model 
{

    protected $table = 'offer_product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('offer_id', 'product_id');

    public function offer()
    {
        return $this->belongsTo('Offer', 'offer_id');
    }

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

}