<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductBranch extends Model 
{

    protected $table = 'product_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'branch_id');

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}