<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('meta_title');
			$table->text('meta_description');
			$table->string('meta_keywords');
			$table->text('other_meta_tags');
			$table->text('title');
			$table->text('slug');
			$table->text('short_description');
			$table->string('time_to_read');
			$table->date('published_on');
			$table->text('blog_img');
			$table->text('blog_img_alt');
			$table->text('description');
			$table->tinyInteger('sort_order');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}