<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->text('meta_tags');
			$table->text('meta_description');
			$table->string('meta_keywords');
			$table->text('other_meta_tags');
			$table->text('title');
			$table->text('slug');
			$table->text('description');
			$table->text('short_description');
			$table->date('published_on');
			$table->string('time_to_read');
			$table->enum('media_type', array('video', 'image'));
			$table->text('media_desktop_path');
			$table->text('media_mobile_path');
			$table->text('media_alt');
			$table->tinyInteger('sort_order');
			$table->boolean('status');
			$table->string('banner_title');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}