<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentTable extends Migration {

	public function up()
	{
		Schema::create('document', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('doc_type', array('GOVERNMENT_ID', 'COMMORBIDITY_DOC'));
			$table->bigInteger('patient_id')->unsigned();
			$table->string('link', 256)->nullable();
			$table->string('name', 255);
		});
	}

	public function down()
	{
		Schema::drop('document');
	}
}