<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->integer('chat_id');
			$table->smallInteger('index');
			$table->text('message');
			$table->boolean('user_to_pro');
			$table->boolean('has_attachment');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}