<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sale extends Eloquent {

	protected $table = 'sales';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'project_id', 'real_estate_details_id', 'price', 'active', 'geoloc_google_ref');

	public function real_estate_detail()
	{
		return $this->hasOne('RealEstateDetails');
	}

	public function estimates()
	{
		return $this->hasMany('SaleEstimate');
	}

	public function progress()
	{
		return $this->hasMany('Progress');
	}

}