<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Search extends Eloquent {

	protected $table = 'searches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'real_estate_details_id', 'type', 'funding_type', 'rent', 'time_limit_type', 'main_house', 'active', 'cities');

	public function real_estate_detail()
	{
		return $this->hasOne('RealEstateDetails');
	}

}