<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProsTable extends Migration {

	public function up()
	{
		Schema::create('pros', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->string('company', 255);
			$table->string('address', 500);
			$table->string('zip', 50);
			$table->string('city', 100);
			$table->string('phone', 50)->nullable();
			$table->string('email', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pros');
	}
}