<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('ticket_category_id')->references('id')->on('ticket_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('ticket_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_ticket_category_id_foreign');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->dropForeign('ticket_replies_ticket_id_foreign');
		});
		Schema::table('ticket_replies', function(Blueprint $table) {
			$table->dropForeign('ticket_replies_employee_id_foreign');
		});
	}
}