<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->longText('notes')->nullable();
			$table->decimal('total_price');
			$table->enum('status', array('respect', 'preparation', 'delivery', 'rejecte', 'accepte'));
			$table->integer('restaurant_id')->unsigned();
			$table->decimal('delivery_charge');
			$table->decimal('commission');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}