<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderTimesTable extends Migration {

	public function up()
	{
		Schema::create('provider_times', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('provider_id')->unsigned()->index();
			$table->string('days')->nullable();
			$table->time('start_time');
			$table->time('end_time');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('provider_times');
	}
}