<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('sku', 255);
			$table->string('upc', 255)->nullable();
			$table->string('name', 255);
			$table->string('cartDescription', 255)->nullable();
			$table->text('description');
			$table->integer('inventory')->default('0');
			$table->float('weight')->nullable()->default('0.00');
			$table->tinyInteger('taxable')->default('0');
			$table->tinyInteger('live')->default('0');
			$table->tinyInteger('retired')->default('0');
			$table->string('slug', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}