<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('id_customer')->references('id_customer')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('id_account_kind')->references('id_account_kind')->on('account_kinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->foreign('id_customer')->references('id_customer')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->foreign('id_license_kind')->references('id_license_kind')->on('license_kinds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->foreign('id_validity_date')->references('id_validity_date')->on('validity_dates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_role')->references('id_role')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('license_attributions', function(Blueprint $table) {
			$table->foreign('id_license')->references('id_license')->on('licenses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('license_attributions', function(Blueprint $table) {
			$table->foreign('id_account')->references('id_account')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('software_sessions', function(Blueprint $table) {
			$table->foreign('id_account')->references('id_account')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('software_sessions', function(Blueprint $table) {
			$table->foreign('id_license')->references('id_license')->on('licenses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_id_customer_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_id_account_kind_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_id_user_foreign');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->dropForeign('licenses_id_customer_foreign');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->dropForeign('licenses_id_license_kind_foreign');
		});
		Schema::table('licenses', function(Blueprint $table) {
			$table->dropForeign('licenses_id_validity_date_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_role_foreign');
		});
		Schema::table('license_attributions', function(Blueprint $table) {
			$table->dropForeign('license_attributions_id_license_foreign');
		});
		Schema::table('license_attributions', function(Blueprint $table) {
			$table->dropForeign('license_attributions_id_account_foreign');
		});
		Schema::table('software_sessions', function(Blueprint $table) {
			$table->dropForeign('software_sessions_id_account_foreign');
		});
		Schema::table('software_sessions', function(Blueprint $table) {
			$table->dropForeign('software_sessions_id_license_foreign');
		});
	}
}