<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageTable extends Migration {

	public function up()
	{
		Schema::create('page', function(Blueprint $table) {
			$table->increments('id');
			$table->text('title');
			$table->string('slug');
			$table->integer('user_id')->unsigned()->index();
			$table->text('content');
			$table->string('status', 20);
			$table->string('comment_status', 20);
			$table->string('password', 30)->nullable();
			$table->integer('page_type_id')->unsigned()->index();
			$table->integer('template_id')->unsigned()->index();
			$table->integer('parent')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->integer('layout_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('page');
	}
}