<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Car extends Eloquent {

	protected $table = 'cars';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function products()
	{
		return $this->hasMany('app\Product');
	}

	public function model()
	{
		return $this->hasOne('app\Model');
	}

}