<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactTable extends Migration {

	public function up()
	{
		Schema::create('contact', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('contact_type', array('Plumber', 'Electrician', 'WaterSupply'));
			$table->string('name');
			$table->string('phone', 15);
			$table->string('alternative_phone')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contact');
	}
}