<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSequenceStepsTable extends Migration {

	public function up()
	{
		Schema::create('sequence_steps', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->integer('author_id');
			$table->integer('sequence_id');
			$table->integer('order')->nullable();
			$table->text('template')->nullable();
			$table->integer('duration');
			$table->string('duration_type', 50);
			$table->integer('duration_in_minutes');
			$table->string('status', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sequence_steps');
	}
}