<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSequencesTable extends Migration {

	public function up()
	{
		Schema::create('sequences', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->string('title');
			$table->integer('author_id');
			$table->integer('client_id');
			$table->string('status', 100);
			$table->timestamp('modified_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sequences');
	}
}