<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->text('objective');
			$table->json('authors')->default('[1001, 1002, 1003]');
			$table->json('tags');
			$table->string('image');
			$table->json('campaigns')->default('[1001, 1002, 1003]');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}