<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCoursesTable extends Migration {

	public function up()
	{
		Schema::create('user_courses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->integer('missions_total');
			$table->integer('missions_completed');
			$table->timestamp('last_played');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_courses');
	}
}