<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('location', 'title', 'address', 'detail');
	protected $visible = array('location', 'title', 'address', 'detail');

	public function creator()
	{
		return $this->hasOne('User', 'user_id');
	}

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function likes()
	{
		return $this->hasMany('Likesevents');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function hashtag()
	{
		return $this->hasMany('Tag');
	}

}