<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'password', 'email');
	protected $visible = array('name', 'password', 'email');

	public function events()
	{
		return $this->hasMany('Event');
	}

}