<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('address', 60);
			$table->smallInteger('postcode')->unsigned()->index();
			$table->string('city', 20);
			$table->string('state', 20);
			$table->integer('customers_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}