<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Dashboards', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('DashComponents', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('Components')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('DashComponents', function(Blueprint $table) {
			$table->foreign('dashboard_id')->references('id')->on('Dashboards')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ArchiveData', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('Components')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ArchiveData', function(Blueprint $table) {
			$table->foreign('dashboard_id')->references('id')->on('Dashboards')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_customer_id_foreign');
		});
		Schema::table('Dashboards', function(Blueprint $table) {
			$table->dropForeign('Dashboards_customer_id_foreign');
		});
		Schema::table('DashComponents', function(Blueprint $table) {
			$table->dropForeign('DashComponents_component_id_foreign');
		});
		Schema::table('DashComponents', function(Blueprint $table) {
			$table->dropForeign('DashComponents_dashboard_id_foreign');
		});
		Schema::table('ArchiveData', function(Blueprint $table) {
			$table->dropForeign('ArchiveData_component_id_foreign');
		});
		Schema::table('ArchiveData', function(Blueprint $table) {
			$table->dropForeign('ArchiveData_dashboard_id_foreign');
		});
	}
}