<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('payment_mappings', function(Blueprint $table) {
			$table->foreign('invoice_mapping_id')->references('id')->on('invoice_mappings')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('batches_invoices_mappings', function(Blueprint $table) {
			$table->foreign('batch_id')->references('id')->on('batches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('batches_invoices_mappings', function(Blueprint $table) {
			$table->foreign('invoice_mapping_id')->references('id')->on('invoice_mappings')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('payment_mappings', function(Blueprint $table) {
			$table->dropForeign('payment_mappings_invoice_mapping_id_foreign');
		});
		Schema::table('batches_invoices_mappings', function(Blueprint $table) {
			$table->dropForeign('batches_invoices_mappings_batch_id_foreign');
		});
		Schema::table('batches_invoices_mappings', function(Blueprint $table) {
			$table->dropForeign('batches_invoices_mappings_invoice_mapping_id_foreign');
		});
	}
}