<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('event_id')->unsigned()->index();
			$table->integer('venue_id')->unsigned()->index();
			$table->string('name');
			$table->string('description')->nullable();
			$table->text('additionals');
			$table->decimal('cost', 10,2);
			$table->enum('status', array('paid', 'unpaid', 'cancelled'));
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('company')->nullable();
			$table->enum('dietary', array('hindu', 'kosher', 'asian', 'vegetarian', 'diabetic'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}