<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->unique();
			$table->integer('client_id');
			$table->string('tax_number')->nullable();
			$table->double('ship_price');
			$table->double('total_product_price');
			$table->string('payment_method');
			$table->text('status');
			$table->text('address')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}